/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.mac;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.software.os.OSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@ThreadSafe
public final class ThreadInfo {
    private static final Pattern PS_M = Pattern.compile("\\D+(\\d+).+(\\d+\\.\\d)\\s+(\\w)\\s+(\\d+)\\D+(\\d+:\\d{2}\\.\\d{2})\\s+(\\d+:\\d{2}\\.\\d{2}).+");

    private ThreadInfo() {
    }

    public static List<ThreadStats> queryTaskThreads(int n) {
        String string = " " + n + " ";
        ArrayList<ThreadStats> arrayList = new ArrayList<ThreadStats>();
        List list = ExecutingCommand.runNative("ps -awwxM").stream().filter(string2 -> string2.contains(string)).collect(Collectors.toList());
        int n2 = 0;
        for (String string3 : list) {
            Matcher matcher = PS_M.matcher(string3);
            if (!matcher.matches() || n != ParseUtil.parseIntOrDefault(matcher.group(1), -1)) continue;
            double d = ParseUtil.parseDoubleOrDefault(matcher.group(2), 0.0);
            char c = matcher.group(3).charAt(0);
            int n3 = ParseUtil.parseIntOrDefault(matcher.group(4), 0);
            long l = ParseUtil.parseDHMSOrDefault(matcher.group(5), 0L);
            long l2 = ParseUtil.parseDHMSOrDefault(matcher.group(6), 0L);
            arrayList.add(new ThreadStats(n2++, d, c, l, l2, n3));
        }
        return arrayList;
    }

    @Immutable
    public static class ThreadStats {
        private final int threadId;
        private final long userTime;
        private final long systemTime;
        private final long upTime;
        private final OSProcess.State state;
        private final int priority;

        public ThreadStats(int n, double d, char c, long l, long l2, int n2) {
            this.threadId = n;
            this.userTime = l2;
            this.systemTime = l;
            this.upTime = (long)((double)(l2 + l) / (d / 100.0 + 5.0E-4));
            switch (c) {
                case 'I': 
                case 'S': {
                    this.state = OSProcess.State.SLEEPING;
                    break;
                }
                case 'U': {
                    this.state = OSProcess.State.WAITING;
                    break;
                }
                case 'R': {
                    this.state = OSProcess.State.RUNNING;
                    break;
                }
                case 'Z': {
                    this.state = OSProcess.State.ZOMBIE;
                    break;
                }
                case 'T': {
                    this.state = OSProcess.State.STOPPED;
                    break;
                }
                default: {
                    this.state = OSProcess.State.OTHER;
                }
            }
            this.priority = n2;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public long getUserTime() {
            return this.userTime;
        }

        public long getSystemTime() {
            return this.systemTime;
        }

        public long getUpTime() {
            return this.upTime;
        }

        public OSProcess.State getState() {
            return this.state;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

