/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows;

import com.sun.jna.Memory;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Cfgmgr32Util;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.ByRef;
import oshi.jna.Struct;
import oshi.util.tuples.Quintet;

@ThreadSafe
public final class DeviceTree {
    private static final int MAX_PATH = 260;
    private static final SetupApi SA = SetupApi.INSTANCE;
    private static final Cfgmgr32 C32 = Cfgmgr32.INSTANCE;

    private DeviceTree() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Quintet<Set<Integer>, Map<Integer, Integer>, Map<Integer, String>, Map<Integer, String>, Map<Integer, String>> queryDeviceTree(Guid.GUID gUID) {
        Object object;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        HashMap<Integer, String> hashMap4 = new HashMap<Integer, String>();
        WinNT.HANDLE hANDLE = SA.SetupDiGetClassDevs(gUID, null, null, 18);
        if (!WinBase.INVALID_HANDLE_VALUE.equals(hANDLE)) {
            try {
                object = new Memory(260L);
                try (ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(260);
                     ByRef.CloseableIntByReference closeableIntByReference2 = new ByRef.CloseableIntByReference();
                     ByRef.CloseableIntByReference closeableIntByReference3 = new ByRef.CloseableIntByReference();
                     Struct.CloseableSpDevinfoData closeableSpDevinfoData = new Struct.CloseableSpDevinfoData();){
                    closeableSpDevinfoData.cbSize = closeableSpDevinfoData.size();
                    ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
                    int n2 = 0;
                    while (SA.SetupDiEnumDeviceInfo(hANDLE, n2, closeableSpDevinfoData)) {
                        arrayDeque.add(closeableSpDevinfoData.DevInst);
                        int n3 = 0;
                        while (!arrayDeque.isEmpty()) {
                            n3 = (Integer)arrayDeque.poll();
                            String string = Cfgmgr32Util.CM_Get_Device_ID(n3);
                            hashMap3.put(n3, string);
                            String string2 = DeviceTree.getDevNodeProperty(n3, 13, (Memory)object, closeableIntByReference);
                            if (string2.isEmpty()) {
                                string2 = DeviceTree.getDevNodeProperty(n3, 1, (Memory)object, closeableIntByReference);
                            }
                            if (string2.isEmpty()) {
                                string2 = DeviceTree.getDevNodeProperty(n3, 8, (Memory)object, closeableIntByReference);
                                String string3 = DeviceTree.getDevNodeProperty(n3, 5, (Memory)object, closeableIntByReference);
                                if (!string3.isEmpty()) {
                                    string2 = string2 + " (" + string3 + ")";
                                }
                            }
                            hashMap2.put(n3, string2);
                            hashMap4.put(n3, DeviceTree.getDevNodeProperty(n3, 12, (Memory)object, closeableIntByReference));
                            if (0 != C32.CM_Get_Child(closeableIntByReference2, n3, 0)) continue;
                            hashMap.put(closeableIntByReference2.getValue(), n3);
                            arrayDeque.add(closeableIntByReference2.getValue());
                            while (0 == C32.CM_Get_Sibling(closeableIntByReference3, closeableIntByReference2.getValue(), 0)) {
                                hashMap.put(closeableIntByReference3.getValue(), n3);
                                arrayDeque.add(closeableIntByReference3.getValue());
                                closeableIntByReference2.setValue(closeableIntByReference3.getValue());
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    ((Memory)object).close();
                }
            }
            finally {
                SA.SetupDiDestroyDeviceInfoList(hANDLE);
            }
        }
        object = hashMap3.keySet().stream().filter(n -> !hashMap.containsKey(n)).collect(Collectors.toSet());
        return new Quintet(object, hashMap, hashMap2, hashMap3, hashMap4);
    }

    private static String getDevNodeProperty(int n, int n2, Memory memory, IntByReference intByReference) {
        memory.clear();
        intByReference.setValue((int)memory.size());
        C32.CM_Get_DevNode_Registry_Property(n, n2, null, memory, intByReference, 0);
        return memory.getWideString(0L);
    }
}

